
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin E
    x1 = model.addVar(name="x1")  # milligrams of calcium
    x2 = model.addVar(name="x2")  # milligrams of vitamin C

    # Objective function
    model.setObjective(5 * x0 + 1 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(24 * x0 <= 108)
    model.addConstr(19 * x0 <= 250)
    model.addConstr(24 * x0 <= 251)
    model.addConstr(25 * x1 <= 108)
    model.addConstr(29 * x1 <= 250)
    model.addConstr(29 * x1 <= 251)
    model.addConstr(13 * x2 <= 108)
    model.addConstr(18 * x2 <= 250)
    model.addConstr(6 * x2 <= 251)
    model.addConstr(24 * x0 + 29 * x1 + 6 * x2 >= 45)
    model.addConstr(28 * x0 + 25 * x1 <= 106)
    model.addConstr(25 * x1 + 13 * x2 <= 70)
    model.addConstr(28 * x0 + 25 * x1 + 13 * x2 <= 70)
    model.addConstr(29 * x1 + 18 * x2 <= 148)
    model.addConstr(19 * x0 + 29 * x1 <= 103)
    model.addConstr(19 * x0 + 29 * x1 + 18 * x2 <= 103)
    model.addConstr(24 * x0 + 29 * x1 <= 137)
    model.addConstr(24 * x0 + 6 * x2 <= 166)
    model.addConstr(29 * x1 + 6 * x2 <= 192)
    model.addConstr(24 * x0 + 29 * x1 + 6 * x2 <= 192)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0 (milligrams of vitamin E): {x0.varValue}")
        print(f"x1 (milligrams of calcium): {x1.varValue}")
        print(f"x2 (milligrams of vitamin C): {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
