
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")


# Set objective function
m.setObjective(7 * peggy + 8 * bobby + 1 * ringo + 1 * laura, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * peggy + 13 * ringo + 11 * laura >= 24)
m.addConstr(1 * peggy + 4 * bobby + 11 * laura >= 24)
m.addConstr(1 * peggy + 4 * bobby + 13 * ringo >= 24)
m.addConstr(1 * peggy + 13 * ringo + 11 * laura >= 18)
m.addConstr(1 * peggy + 4 * bobby + 11 * laura >= 18)
m.addConstr(1 * peggy + 4 * bobby + 13 * ringo >= 18)
m.addConstr(1 * peggy + 13 * ringo + 11 * laura >= 32)
m.addConstr(1 * peggy + 4 * bobby + 11 * laura >= 32)
m.addConstr(1 * peggy + 4 * bobby + 13 * ringo >= 32)
m.addConstr(12 * peggy + 11 * ringo >= 30)
m.addConstr(10 * bobby + 10 * laura >= 23)
m.addConstr(12 * peggy + 10 * bobby + 10 * laura >= 20)
m.addConstr(1 * peggy + 4 * bobby <= 110)
m.addConstr(13 * ringo + 11 * laura <= 54)
m.addConstr(1 * peggy + 4 * bobby + 13 * ringo + 11 * laura <= 54)
m.addConstr(12 * peggy + 10 * laura <= 98)
m.addConstr(12 * peggy + 11 * ringo <= 50)
m.addConstr(10 * bobby + 10 * laura <= 78)
m.addConstr(11 * ringo + 10 * laura <= 110)
m.addConstr(12 * peggy + 10 * bobby <= 32)
m.addConstr(12 * peggy + 10 * bobby + 10 * laura <= 109)
m.addConstr(12 * peggy + 10 * bobby + 11 * ringo + 10 * laura <= 109)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

