
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='hours_worked_by_Peggy', lb=0)
x1 = m.addVar(name='hours_worked_by_Bobby', lb=0)
x2 = m.addVar(name='hours_worked_by_Ringo', lb=0)
x3 = m.addVar(name='hours_worked_by_Laura', lb=0)

# Define the objective function
m.setObjective(7 * x0 + 8 * x1 + x2 + x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * x0 + 13 * x2 + 11 * x3 >= 24)
m.addConstr(1 * x0 + 4 * x1 + 11 * x3 >= 24)
m.addConstr(1 * x0 + 4 * x1 + 13 * x2 >= 24)
m.addConstr(1 * x0 + 13 * x2 + 11 * x3 >= 18)
m.addConstr(1 * x0 + 4 * x1 + 11 * x3 >= 18)
m.addConstr(1 * x0 + 4 * x1 + 13 * x2 >= 18)
m.addConstr(1 * x0 + 13 * x2 + 11 * x3 >= 32)
m.addConstr(1 * x0 + 4 * x1 + 11 * x3 >= 32)
m.addConstr(1 * x0 + 4 * x1 + 13 * x2 >= 32)
m.addConstr(12 * x0 + 11 * x2 >= 30)
m.addConstr(10 * x1 + 10 * x3 >= 23)
m.addConstr(12 * x0 + 10 * x1 + 10 * x3 >= 20)
m.addConstr(1 * x0 + 4 * x1 <= 110)
m.addConstr(13 * x2 + 11 * x3 <= 54)
m.addConstr(1 * x0 + 4 * x1 + 13 * x2 + 11 * x3 <= 54)
m.addConstr(12 * x0 + 10 * x3 <= 98)
m.addConstr(12 * x0 + 11 * x2 <= 50)
m.addConstr(10 * x1 + 10 * x3 <= 78)
m.addConstr(11 * x2 + 10 * x3 <= 110)
m.addConstr(12 * x0 + 10 * x1 <= 32)
m.addConstr(12 * x0 + 10 * x1 + 10 * x3 <= 109)
m.addConstr(12 * x0 + 10 * x1 + 11 * x2 + 10 * x3 <= 109)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by Peggy: ', x0.varValue)
    print('Hours worked by Bobby: ', x1.varValue)
    print('Hours worked by Ringo: ', x2.varValue)
    print('Hours worked by Laura: ', x3.varValue)
else:
    print('The problem is infeasible')
