
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams_of_fat")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_calcium")


    # Set objective function
    m.setObjective(2*x0 + 6*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 10*x1 >= 42, "c0")
    m.addConstr(14*x0 + x1 >= 49, "c1")
    m.addConstr(9*x0 - 8*x1 >= 0, "c2")
    m.addConstr(3*x0 + 10*x1 <= 88, "c3")
    m.addConstr(14*x0 + x1 <= 62, "c4")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("grams of fat:", x0.x)
        print("milligrams of calcium:", x1.x)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')

