
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(name='grams_of_fat', lb=-GRB.INFINITY)  # No lower bound for x1, assuming it can be any real number
x2 = m.addVar(name='milligrams_of_calcium', lb=-GRB.INFINITY)  # No lower bound for x2

# Define the objective function: Maximize 2*x1 + 6*x2
m.setObjective(2*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 10*x2 >= 42, name='cardiovascular_support_index_min')
m.addConstr(14*x1 + x2 >= 49, name='energy_stability_index_min')
m.addConstr(9*x1 - 8*x2 >= 0, name='mixed_constraint')
m.addConstr(3*x1 + 10*x2 <= 88, name='cardiovascular_support_index_max')
m.addConstr(14*x1 + x2 <= 62, name='energy_stability_index_max')

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.x}, x2 = {x2.x}")
else:
    print("No optimal solution found")
