
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_fat", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="milligrams_of_calcium", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(2*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x1 + 10*x2 >= 42)
    model.addConstr(14*x1 + x2 >= 49)
    model.addConstr(9*x1 - 8*x2 >= 0)
    model.addConstr(3*x1 + 10*x2 <= 88)
    model.addConstr(14*x1 + x2 <= 62)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fat: {x1.varValue}")
        print(f"Milligrams of calcium: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
