
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
bobby = m.addVar(vtype=GRB.CONTINUOUS, name="bobby")
dale = m.addVar(vtype=GRB.CONTINUOUS, name="dale")
paul = m.addVar(vtype=GRB.INTEGER, name="paul")
john = m.addVar(vtype=GRB.INTEGER, name="john")


# Set objective function
m.setObjective(2*bobby + 5*dale + 7*paul + 3*john, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*bobby + 5*john >= 20)
m.addConstr(3*paul + 5*john >= 16)
m.addConstr(2*bobby + 5*dale + 3*paul + 5*john >= 16)
m.addConstr(3*dale + 2*paul >= 22)
m.addConstr(3*dale + 5*john >= 29)
m.addConstr(2*bobby + 5*john >= 29)
m.addConstr(2*bobby + 2*paul >= 29)
m.addConstr(2*bobby + 3*dale + 2*paul + 5*john >= 29)
m.addConstr(4*bobby + 5*paul >= 8)
m.addConstr(4*bobby + 3*dale >= 7)
m.addConstr(3*dale + 2*john >= 9)
m.addConstr(4*bobby + 3*dale + 5*paul >= 6)
m.addConstr(3*dale + 5*paul + 2*john >= 6)
m.addConstr(4*bobby + 3*dale + 5*paul >= 5)
m.addConstr(3*dale + 5*paul + 2*john >= 5)
m.addConstr(4*bobby + 3*dale + 5*paul + 2*john >= 5)
m.addConstr(4*bobby + 2*dale >= 17)
m.addConstr(2*dale + 4*john >= 17)
m.addConstr(4*bobby + 2*dale + 4*paul + 4*john >= 17)
m.addConstr(4*bobby + paul >= 6)
m.addConstr(paul + john >= 9)
m.addConstr(dale + paul >= 12)
m.addConstr(dale + john >= 14)
m.addConstr(4*bobby + dale >= 5)
m.addConstr(4*bobby + dale + paul >= 8)
m.addConstr(4*bobby + dale + john >= 8)
m.addConstr(dale + paul + john >= 8)
m.addConstr(4*bobby + dale + paul >= 11)
m.addConstr(4*bobby + dale + john >= 11)
m.addConstr(dale + paul + john >= 11)
m.addConstr(4*bobby + dale + paul >= 16)
m.addConstr(4*bobby + dale + john >= 16)
m.addConstr(dale + paul + john >= 16)
m.addConstr(4*bobby + dale + paul + john >= 16)
m.addConstr(5*dale + 3*paul <= 69)
m.addConstr(2*bobby + 5*john <= 87)
m.addConstr(5*dale + 3*paul + 5*john <= 24)
m.addConstr(2*bobby + 5*dale + 3*paul <= 39)
m.addConstr(2*bobby + 5*dale + 5*john <= 64)
m.addConstr(3*dale + 2*paul <= 36)
m.addConstr(2*bobby + 2*paul <= 71)
m.addConstr(2*bobby + 2*paul + 5*john <= 105)
m.addConstr(3*dale + 2*paul + 5*john <= 83)
m.addConstr(2*bobby + 3*dale + 5*john <= 85)
m.addConstr(2*bobby + 3*dale + 2*paul <= 47)
m.addConstr(4*bobby + 3*dale <= 13)
m.addConstr(4*bobby + 5*paul + 2*john <= 42)
m.addConstr(4*bobby + 3*dale + 5*paul <= 11)
m.addConstr(4*bobby + 2*dale <= 79)
m.addConstr(dale + paul <= 48)
m.addConstr(4*bobby + paul <= 28)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

