
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
    orange_trees = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")

    # Set objective function
    m.setObjective(2.08 * agave + 3.75 * orange_trees, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13 * agave + 15 * orange_trees >= 37, "resilience_lower")
    m.addConstr(9 * agave + 12 * orange_trees >= 42, "cost_lower")
    m.addConstr(-4 * agave + 7 * orange_trees >= 0, "agave_orange_ratio")
    m.addConstr(13 * agave + 15 * orange_trees <= 43, "resilience_upper")
    m.addConstr(9 * agave + 12 * orange_trees <= 85, "cost_upper")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('agave:', agave.x)
        print('orange_trees:', orange_trees.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

