
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="agave")
x1 = m.addVar(vtype=GRB.INTEGER, name="orange_trees")

# Set the objective function
m.setObjective(2.08*x0 + 3.75*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x0 + 15*x1 >= 37, "resilience_index_lower")
m.addConstr(13*x0 + 15*x1 <= 43, "resilience_index_upper")
m.addConstr(9*x0 + 12*x1 >= 42, "cost_lower")
m.addConstr(9*x0 + 12*x1 <= 85, "cost_upper")
m.addConstr(-4*x0 + 7*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Agave: {x0.x}")
    print(f"Orange Trees: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
