
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="agave", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="orange_trees", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(2.08*x1 + 3.75*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x1 + 15*x2 >= 37)
    model.addConstr(9*x1 + 12*x2 >= 42)
    model.addConstr(-4*x1 + 7*x2 >= 0)
    model.addConstr(13*x1 + 15*x2 <= 43)
    model.addConstr(9*x1 + 12*x2 <= 85)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Agave: {x1.varValue}")
        print(f"Orange Trees: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
