
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
steaks = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="steaks")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")


# Set objective function
m.setObjective(5*tomatoes**2 + 9*tomatoes*cornichons + 6*tomatoes*steaks + 5*tomatoes*strawberries + 2*cornichons**2 + 3*cornichons*steaks + 2*steaks**2 + 8*steaks*strawberries + 3*strawberries**2 + 2*tomatoes + 4*cornichons + 5*steaks + 4*strawberries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11*tomatoes + 17*cornichons + 16*steaks + 5*strawberries <= 562, "iron_upper_bound")
m.addConstr(tomatoes**2 + cornichons**2 >= 98, "tomatoes_cornichons_iron")
m.addConstr(17*cornichons + 16*steaks >= 123, "cornichons_steaks_iron")
m.addConstr(16*steaks + 5*strawberries >= 72, "steaks_strawberries_iron")
m.addConstr(17*cornichons + 5*strawberries >= 114, "cornichons_strawberries_iron")
m.addConstr(11*tomatoes + 16*steaks >= 49, "tomatoes_steaks_iron")
m.addConstr(11*tomatoes + 17*cornichons + 16*steaks + 5*strawberries >= 49, "total_iron_lower_bound")
m.addConstr(-tomatoes**2 + 9*strawberries**2 >= 0, "tomatoes_strawberries_squared_iron")
m.addConstr(cornichons**2 + steaks**2 <= 489, "cornichons_steaks_squared_iron_upper_bound")
m.addConstr(11*tomatoes + 16*steaks + 5*strawberries <= 516, "tomatoes_steaks_strawberries_iron_upper_bound")
m.addConstr(tomatoes**2 + cornichons**2 + steaks**2 <= 373, "tomatoes_cornichons_steaks_squared_iron_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

