
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
tomatoes = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="tomatoes")
cornichons = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="cornichons")
steaks = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, type=gp.GRB.INTEGER, name="steaks")
strawberries = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="strawberries")

# Objective function
m.setObjective(5*tomatoes**2 + 9*tomatoes*cornichons + 6*tomatoes*steaks + 5*tomatoes*strawberries + 
               2*cornichons**2 + 3*cornichons*steaks + 2*steaks**2 + 8*steaks*strawberries + 
               3*strawberries**2 + 2*tomatoes + 4*cornichons + 5*steaks + 4*strawberries, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(11*tomatoes**2 + 17*cornichons**2 >= 98, name="iron_from_tomatoes_and_cornichons")
m.addConstr(17*cornichons + 16*steaks >= 123, name="iron_from_cornichons_and_steaks")
m.addConstr(16*steaks + 5*strawberries >= 72, name="iron_from_steaks_and_strawberries")
m.addConstr(17*cornichons + 5*strawberries >= 114, name="iron_from_cornichons_and_strawberries")
m.addConstr(11*tomatoes + 16*steaks >= 49, name="iron_from_tomatoes_and_steaks")
m.addConstr(11*tomatoes + 17*cornichons + 16*steaks + 5*strawberries >= 49, name="total_iron")
m.addConstr(-tomatoes**2 + 9*strawberries**2 >= 0, name="strawberries_vs_tomatoes")
m.addConstr(17**2*cornichons**2 + 16**2*steaks**2 <= 489, name="cornichons_and_steaks_squared")
m.addConstr(11*tomatoes + 16*steaks + 5*strawberries <= 516, name="total_iron_limit")
m.addConstr(11**2*tomatoes**2 + 17**2*cornichons**2 + 16**2*steaks**2 <= 373, name="total_squared_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Tomatoes: ", tomatoes.varValue)
    print("Cornichons: ", cornichons.varValue)
    print("Steaks: ", steaks.varValue)
    print("Strawberries: ", strawberries.varValue)
else:
    print("The model is infeasible")
