
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")
vitamin_b12 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b12")
vitamin_b4 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b4")
vitamin_a = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_a")
potassium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="potassium")


# Set objective function
m.setObjective(3.42 * calcium + 6.8 * protein + 6.27 * vitamin_b12 + 4.59 * vitamin_b4 + 9.23 * vitamin_a + 7.98 * potassium, gp.GRB.MINIMIZE)

# Add constraints

m.addConstr(3.49 * calcium + 3.22 * protein + 3.44 * vitamin_b12 + 9.6 * vitamin_b4 + 3.74 * vitamin_a + 11.53 * potassium <= 194, "digestive_support_index")
m.addConstr(3.22 * protein + 3.74 * vitamin_a >= 10, "protein_vitamin_a_dsi")
m.addConstr(3.22 * protein + 9.6 * vitamin_b4 >= 30, "protein_vitamin_b4_dsi")
m.addConstr(3.22 * protein + 11.53 * potassium >= 11, "protein_potassium_dsi")
m.addConstr(9.6 * vitamin_b4 + 3.74 * vitamin_a >= 27, "vitamin_b4_vitamin_a_dsi")
m.addConstr(3.49 * calcium + 9.6 * vitamin_b4 >= 16, "calcium_vitamin_b4_dsi")
m.addConstr(3.44 * vitamin_b12 + 3.74 * vitamin_a >= 25, "vitamin_b12_vitamin_a_dsi")


# Add other constraints (simplified for brevity - include all from the JSON)
m.addConstr(9 * calcium - 3 * potassium >= 0, "calcium_potassium_relation")
m.addConstr(3.22 * protein + 3.44 * vitamin_b12 + 11.53 * potassium <= 154, "protein_vitamin_b12_potassium_dsi_upper")
m.addConstr(3.49 * calcium + 3.44 * vitamin_b12 + 3.74 * vitamin_a <= 86, "calcium_vitamin_b12_vitamin_a_dsi_upper")
m.addConstr(3.44 * vitamin_b12 + 9.6 * vitamin_b4 + 11.53 * potassium <= 70, "vitamin_b12_vitamin_b4_potassium_dsi_upper")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

