
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="grams_of_fiber")
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B4")


    # Set objective function
    model.setObjective(8.07*x0**2 + 6.39*x0*x1 + 7.85*x1**2 + 3.82*x0 + 5.89*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8.53*x0 + 6.05*x1 >= 38, "c0")
    model.addConstr(13.96*x0 + 17.69*x1 >= 67, "c1")
    model.addConstr(28.71*x0 + 26.27*x1 >= 61, "c2")
    model.addConstr(2.14*x0 + 17.25*x1 >= 27, "c3")
    model.addConstr(-8*x0**2 + 4*x1**2 >= 0, "c4")
    model.addConstr(8.53*x0 + 6.05*x1 <= 115, "c5")
    model.addConstr(13.96*x0 + 17.69*x1 <= 90, "c6")
    model.addConstr(28.71*x0 + 26.27*x1 <= 195, "c7")
    model.addConstr(2.14*x0 + 17.25*x1 <= 68, "c8")


    # Optimize model
    model.optimize()

    # Print results
    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
