
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # grams of fiber
    x2 = model.addVar(name="x2")  # milligrams of vitamin B4
    
    # Objective function
    model.setObjective(8.07 * x1**2 + 6.39 * x1 * x2 + 7.85 * x2**2 + 3.82 * x1 + 5.89 * x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(8.53 * x1 + 6.05 * x2 >= 38)
    model.addConstr(13.96 * x1 + 17.69 * x2 >= 67)
    model.addConstr(28.71 * x1 + 26.27 * x2 >= 61)
    model.addConstr(2.14 * x1 + 17.25 * x2 >= 27)
    model.addConstr(-8 * x1**2 + 4 * x2**2 >= 0)
    model.addConstr(8.53 * x1 + 6.05 * x2 <= 115)
    model.addConstr(13.96 * x1 + 17.69 * x2 <= 90)
    model.addConstr(28.71 * x1 + 26.27 * x2 <= 193)
    model.addConstr(2.14 * x1 + 17.25 * x2 <= 68)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
