
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_instant_ramen")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hamburgers")


# Set objective function
m.setObjective(7.17*x0**2 + 7.28*x1**2 + 4.4*x1*x2 + 4.41*x2*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 15*x3 >= 22)
m.addConstr(6*x0 + 2*x2 >= 14)
m.addConstr(6*x0**2 + 16*x1**2 + 2*x2**2 >= 21)
m.addConstr(6*x0 + 16*x1 + 15*x3 >= 21)
m.addConstr(6*x0**2 + 16*x1**2 + 2*x2**2 >= 18)
m.addConstr(6*x0 + 16*x1 + 15*x3 >= 18)
m.addConstr(14*x0 + 16*x3 >= 29)
m.addConstr(14*x0 + 4*x1 >= 21)
m.addConstr(14*x0 + 4*x1 + 10*x2 >= 23)
m.addConstr(2*x2**2 + 15*x3**2 <= 87)
m.addConstr(6*x0**2 + 15*x3**2 <= 74)
m.addConstr(16*x1**2 + 2*x2**2 <= 66)
m.addConstr(6*x0**2 + 16*x1**2 <= 95)
m.addConstr(6*x0 + 16*x1 + 2*x2 + 15*x3 <= 95)
m.addConstr(14*x0**2 + 4*x1**2 <= 93)
m.addConstr(14*x0**2 + 10*x2**2 <= 110)
m.addConstr(4*x1 + 16*x3 <= 100)
m.addConstr(4*x1 + 10*x2 <= 139)
m.addConstr(14*x0**2 + 4*x1**2 + 10*x2**2 <= 119)
m.addConstr(4*x1**2 + 10*x2**2 + 16*x3**2 <= 117)
m.addConstr(14*x0 + 4*x1 + 16*x3 <= 126)
m.addConstr(14*x0 + 4*x1 + 10*x2 + 16*x3 <= 126)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

