
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # bowls of instant ramen
x1 = m.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # granola bars
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # green beans
x3 = m.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # hamburgers

# Objective function
m.setObjective(7.17 * x0**2 + 7.28 * x1**2 + 4.4 * x1 * x2 + 4.41 * x2 * x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6 * x0 + 15 * x3 >= 22)
m.addConstr(6 * x0 + 2 * x2 >= 14)
m.addConstr(36 * x0**2 + 256 * x1**2 + 4 * x2**2 >= 21)
m.addConstr(6 * x0 + 16 * x1 + 15 * x3 >= 21)
m.addConstr(36 * x0**2 + 256 * x1**2 + 4 * x2**2 >= 18)
m.addConstr(6 * x0 + 16 * x1 + 15 * x3 >= 18)
m.addConstr(14 * x0 + 16 * x3 >= 29)
m.addConstr(14 * x0 + 4 * x1 >= 21)
m.addConstr(14 * x0 + 4 * x1 + 10 * x2 >= 23)
m.addConstr(4 * x2**2 + 225 * x3**2 <= 87)
m.addConstr(36 * x0**2 + 225 * x3**2 <= 74)
m.addConstr(256 * x1**2 + 4 * x2**2 <= 66)
m.addConstr(36 * x0**2 + 256 * x1**2 <= 95)
m.addConstr(6 * x0 + 4 * x1 + 2 * x2 + 15 * x3 <= 95)
m.addConstr(196 * x0**2 + 16 * x1**2 <= 93)
m.addConstr(196 * x0**2 + 100 * x2**2 <= 110)
m.addConstr(4 * x1 + 16 * x3 <= 100)
m.addConstr(4 * x1 + 10 * x2 <= 139)
m.addConstr(196 * x0**2 + 16 * x1**2 + 100 * x2**2 <= 119)
m.addConstr(16 * x1**2 + 100 * x2**2 + 256 * x3**2 <= 117)
m.addConstr(14 * x0 + 4 * x1 + 16 * x3 <= 126)
m.addConstr(14 * x0 + 4 * x1 + 10 * x2 + 16 * x3 <= 126)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
