
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Hank")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Peggy")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Dale")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Laura")


# Set objective function
m.setObjective(3*hank + 1*peggy + 1*dale + 6*laura, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9.78*hank + 10.71*peggy >= 6)
m.addConstr(10.71*peggy + 0.25*laura >= 6)
m.addConstr(9.78*hank + 0.25*laura >= 18)
m.addConstr(9.78*hank + 1.77*dale >= 11)
m.addConstr(9.78*hank + 10.71*peggy + 1.77*dale + 0.25*laura >= 11)
m.addConstr(9.7*hank + 5.48*laura >= 8)
m.addConstr(7.36*peggy + 6.5*dale >= 16)
m.addConstr(9.7*hank + 6.5*dale >= 19)
m.addConstr(6.5*dale + 5.48*laura >= 12)
m.addConstr(7.36*peggy + 5.48*laura >= 15)
m.addConstr(7.36*peggy + 6.5*dale + 5.48*laura >= 9)
m.addConstr(9.7*hank + 7.36*peggy + 6.5*dale >= 9)
m.addConstr(7.36*peggy + 6.5*dale + 5.48*laura >= 17)
m.addConstr(9.7*hank + 7.36*peggy + 6.5*dale >= 17)
m.addConstr(9.7*hank + 7.36*peggy + 6.5*dale + 5.48*laura >= 17)
m.addConstr(1.73*hank + 7.28*laura >= 15)
m.addConstr(1.73*hank + 5.19*peggy >= 8)
m.addConstr(5.19*peggy + 7.26*dale >= 14)
m.addConstr(1.73*hank + 7.26*dale >= 15)
m.addConstr(1.73*hank + 5.19*peggy + 7.26*dale + 7.28*laura >= 15)
m.addConstr(1*hank - 8*dale >= 0)
m.addConstr(10.71*peggy + 0.25*laura <= 28)
m.addConstr(6.5*dale + 5.48*laura <= 72)
m.addConstr(9.7*hank + 5.48*laura <= 58)
m.addConstr(7.36*peggy + 5.48*laura <= 25)
m.addConstr(9.7*hank + 7.36*peggy <= 39)
m.addConstr(1.73*hank + 7.26*dale <= 30)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

