
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="x2", lb=0)  # hours worked by Dale
x3 = m.addVar(name="x3", lb=0)  # hours worked by Laura

# Objective function
m.setObjective(3*x0 + x1 + x2 + 6*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(9.78*x0 + 10.71*x1 >= 6)
m.addConstr(10.71*x1 + 0.25*x3 >= 6)
m.addConstr(9.78*x0 + 0.25*x3 >= 18)
m.addConstr(9.78*x0 + 1.77*x2 >= 11)
m.addConstr(9.78*x0 + 10.71*x1 + 1.77*x2 + 0.25*x3 >= 11)
m.addConstr(9.7*x0 + 5.48*x3 >= 8)
m.addConstr(7.36*x1 + 6.5*x2 >= 16)
m.addConstr(9.7*x0 + 6.5*x2 >= 19)
m.addConstr(6.5*x2 + 5.48*x3 >= 12)
m.addConstr(7.36*x1 + 5.48*x3 >= 15)
m.addConstr(7.36*x1 + 6.5*x2 + 5.48*x3 >= 9)
m.addConstr(9.7*x0 + 7.36*x1 + 6.5*x2 >= 9)
m.addConstr(7.36*x1 + 6.5*x2 + 5.48*x3 >= 17)
m.addConstr(9.7*x0 + 7.36*x1 + 6.5*x2 >= 17)
m.addConstr(9.7*x0 + 7.36*x1 + 6.5*x2 + 5.48*x3 >= 17)
m.addConstr(1.73*x0 + 7.28*x3 >= 15)
m.addConstr(1.73*x0 + 5.19*x1 >= 8)
m.addConstr(5.19*x1 + 7.26*x2 >= 14)
m.addConstr(1.73*x0 + 7.26*x2 >= 15)
m.addConstr(1.73*x0 + 5.19*x1 + 7.26*x2 + 7.28*x3 >= 15)
m.addConstr(x0 - 8*x2 >= 0)
m.addConstr(10.71*x1 + 0.25*x3 <= 28)
m.addConstr(6.5*x2 + 5.48*x3 <= 72)
m.addConstr(9.7*x0 + 5.48*x3 <= 58)
m.addConstr(7.36*x1 + 5.48*x3 <= 25)
m.addConstr(9.7*x0 + 7.36*x1 <= 39)
m.addConstr(1.73*x0 + 7.26*x2 <= 30)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Dale: ", x2.varValue)
    print("Hours worked by Laura: ", x3.varValue)
else:
    print("The model is infeasible")
