
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="patches per day")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="network administrators")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="system administrators")
    x4 = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion analysts")
    x5 = m.addVar(vtype=gp.GRB.INTEGER, name="security engineers")


    # Set objective function
    m.setObjective(2*x0 + 1*x1 + 6*x2 + 9*x3 + 8*x4 + 3*x5, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(21*x0 + 1*x1 + 9*x2 + 23*x3 + 15*x4 + 5*x5 <= 450, "power_consumption")
    m.addConstr(x1 + 5*x5 >= 30, "c1")
    m.addConstr(21*x0 + 23*x3 >= 63, "c2")
    m.addConstr(23*x3 + 5*x5 >= 63, "c3")
    m.addConstr(x1 + 9*x2 >= 50, "c4")
    m.addConstr(21*x0 + x1 >= 43, "c5")
    m.addConstr(15*x4 + 5*x5 >= 52, "c6")
    m.addConstr(9*x2 + 23*x3 >= 46, "c7")
    m.addConstr(21*x0 + 15*x4 >= 55, "c8")
    m.addConstr(21*x0 + x1 + 9*x2 + 23*x3 + 15*x4 + 5*x5 >= 55, "c9")
    m.addConstr(-3*x2 + 3*x5 >= 0, "c10")
    m.addConstr(x1 + 9*x2 <= 354, "c11")
    m.addConstr(21*x0 + x1 <= 299, "c12")
    m.addConstr(x1 + 5*x5 <= 410, "c13")
    m.addConstr(21*x0 + 15*x4 <= 379, "c14")
    m.addConstr(21*x0 + 15*x4 + 5*x5 <= 265, "c15")
    m.addConstr(9*x2 + 15*x4 + 5*x5 <= 143, "c16")
    m.addConstr(21*x0 + x1 + 23*x3 <= 272, "c17")
    m.addConstr(x1 + 23*x3 + 15*x4 <= 352, "c18")
    m.addConstr(21*x0 + 23*x3 + 15*x4 <= 144, "c19")
    m.addConstr(9*x2 + 23*x3 + 15*x4 <= 247, "c20")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
