
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # bowls of instant ramen
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # steaks
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # peanutbutter sandwiches
x3 = m.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # granola bars

# Objective function
m.setObjective(3.62*x0**2 + 4.63*x0*x1 + 5.03*x0*x3 + 2.07*x1**2 + 6.03*x1*x2 + 3.6*x1*x3 + 6.97*x2**2 + 7.45*x2*x3 + 4.02*x3**2 + 9.15*x0 + 9.81*x1 + 8.4*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3.51*x0 <= 139)
m.addConstr(1.79*x0 <= 203)
m.addConstr(7.74*x0 <= 161)
m.addConstr(0.65*x1 <= 139)
m.addConstr(5.28*x1 <= 203)
m.addConstr(7.25*x1 <= 161)
m.addConstr(8.37*x2 <= 139)
m.addConstr(7.08*x2 <= 203)
m.addConstr(6.01*x2 <= 161)
m.addConstr(1.67*x3 <= 139)
m.addConstr(7.75*x3 <= 203)
m.addConstr(7.62*x3 <= 161)
m.addConstr(7.74*x0 + 6.01*x2 >= 29)
m.addConstr((8.37*x2)**2 + (1.67*x3)**2 <= 44)
m.addConstr(3.51*x0 + 0.65*x1 <= 59)
m.addConstr(3.51*x0 + 8.37*x2 <= 104)
m.addConstr((0.65*x1)**2 + (1.67*x3)**2 <= 95)
m.addConstr(3.51*x0 + 0.65*x1 + 8.37*x2 <= 65)
m.addConstr(3.51*x0 + 0.65*x1 + 8.37*x2 + 1.67*x3 <= 65)
m.addConstr((5.28*x1)**2 + (7.08*x2)**2 <= 59)
m.addConstr(1.79*x0 + 7.08*x2 <= 56)
m.addConstr(1.79*x0 + 5.28*x1 <= 109)
m.addConstr((5.28*x1)**2 + (7.75*x3)**2 <= 85)
m.addConstr(1.79*x0 + 5.28*x1 + 7.08*x2 + 7.75*x3 <= 85)
m.addConstr(7.74*x0 + 6.01*x2 <= 140)
m.addConstr((7.74*x0)**2 + (7.62*x3)**2 <= 56)
m.addConstr(7.25*x1 + 6.01*x2 <= 105)
m.addConstr(7.74*x0 + 7.25*x1 + 6.01*x2 + 7.62*x3 <= 105)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bowls of instant ramen: ", x0.varValue)
    print("steaks: ", x1.varValue)
    print("peanutbutter sandwiches: ", x2.varValue)
    print("granola bars: ", x3.varValue)
else:
    print("The model is infeasible")
