
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # grams of fiber
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B4
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B5


    # Set objective function
    m.setObjective(1*x0 + 7*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(34*x1 + 20*x2 >= 103, "c1")
    m.addConstr(13*x0 + 29*x1 >= 59, "c2")
    m.addConstr(21*x0 + 26*x2 <= 353, "c3")
    m.addConstr(21*x0 + 30*x1 + 26*x2 <= 353, "c4")
    m.addConstr(23*x0 + 31*x2 <= 148, "c5")
    m.addConstr(28*x1 + 31*x2 <= 130, "c6")
    m.addConstr(23*x0 + 28*x1 + 31*x2 <= 130, "c7")
    m.addConstr(14*x0 + 19*x2 <= 357, "c8")
    m.addConstr(14*x0 + 14*x1 <= 261, "c9")
    m.addConstr(14*x0 + 14*x1 + 19*x2 <= 261, "c10")
    m.addConstr(34*x1 + 20*x2 <= 517, "c11")
    m.addConstr(8*x0 + 20*x2 <= 301, "c12")
    m.addConstr(8*x0 + 34*x1 + 20*x2 <= 301, "c13")
    m.addConstr(13*x0 + 29*x1 <= 386, "c14")
    m.addConstr(13*x0 + 15*x2 <= 367, "c15")
    m.addConstr(13*x0 + 29*x1 + 15*x2 <= 367, "c16")

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
