
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=-float('inf'), ub=float('inf'))
    x1 = model.addVar(name="x1", lb=-float('inf'), ub=float('inf'))
    x2 = model.addVar(name="x2", lb=-float('inf'), ub=float('inf'))

    # Define the objective function
    model.setObjective(1 * x0 + 7 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(21 * x0 <= 365)
    model.addConstr(23 * x0 <= 255)
    model.addConstr(14 * x0 <= 387)
    model.addConstr(8 * x0 <= 530)
    model.addConstr(13 * x0 <= 396)
    model.addConstr(30 * x1 <= 365)
    model.addConstr(28 * x1 <= 255)
    model.addConstr(14 * x1 <= 387)
    model.addConstr(34 * x1 <= 530)
    model.addConstr(29 * x1 <= 396)
    model.addConstr(26 * x2 <= 365)
    model.addConstr(31 * x2 <= 255)
    model.addConstr(19 * x2 <= 387)
    model.addConstr(20 * x2 <= 530)
    model.addConstr(15 * x2 <= 396)
    model.addConstr(34 * x1 + 20 * x2 >= 103)
    model.addConstr(13 * x0 + 29 * x1 >= 59)
    model.addConstr(21 * x0 + 26 * x2 <= 353)
    model.addConstr(21 * x0 + 30 * x1 + 26 * x2 <= 353)
    model.addConstr(23 * x0 + 31 * x2 <= 148)
    model.addConstr(28 * x1 + 31 * x2 <= 130)
    model.addConstr(23 * x0 + 28 * x1 + 31 * x2 <= 130)
    model.addConstr(14 * x0 + 19 * x2 <= 357)
    model.addConstr(14 * x0 + 14 * x1 <= 261)
    model.addConstr(14 * x0 + 14 * x1 + 19 * x2 <= 261)
    model.addConstr(34 * x1 + 20 * x2 <= 517)
    model.addConstr(8 * x0 + 20 * x2 <= 301)
    model.addConstr(8 * x0 + 34 * x1 + 20 * x2 <= 301)
    model.addConstr(13 * x0 + 29 * x1 <= 386)
    model.addConstr(13 * x0 + 15 * x2 <= 367)
    model.addConstr(13 * x0 + 29 * x1 + 15 * x2 <= 367)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
