
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B3
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # grams of fiber
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # milligrams of vitamin K
    x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3") # grams of carbohydrates


    # Set objective function
    m.setObjective(4.8*x0**2 + 2.12*x0*x1 + 6.97*x0*x2 + 8.25*x1**2 + 7.81*x1*x2 + 3.96*x0 + 8.16*x1 + 7.57*x3, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(x0 + x2 >= 17, "c1")
    m.addConstr(x2**2 + x3**2 >= 17, "c2")
    m.addConstr(x0 + x1 >= 12, "c3")
    m.addConstr(x0 + x1 + x2 + x3 >= 12, "c4")
    m.addConstr(-5*x0 + 3*x1 >= 0, "c5")
    m.addConstr(-x0**2 + 2*x2**2 >= 0, "c6")
    m.addConstr(-2*x1 + 5*x2 + 2*x3 >= 0, "c7")
    m.addConstr(x0 + x3 <= 29, "c8")
    m.addConstr(x0 + x1 <= 23, "c9")
    m.addConstr(1*x0 + 5*x1 + 2*x2 + 2*x3 <= 76, "c10")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
