
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="milligrams of vitamin B3")
    x2 = model.addVar(lb=0, name="grams of fiber")
    x3 = model.addVar(lb=0, name="milligrams of vitamin K")
    x4 = model.addVar(lb=0, name="grams of carbohydrates")

    # Objective function
    model.setObjective(4.8*x1**2 + 2.12*x1*x2 + 6.97*x1*x3 + 8.25*x2**2 + 7.81*x2*x3 + 3.96*x1 + 8.16*x2 + 7.57*x4)

    # Constraints
    model.addConstr(x1 + 5*x2 + 2*x3 + 2*x4 <= 76)
    model.addConstr(x1 >= 1)
    model.addConstr(5*x2 >= 5)
    model.addConstr(2*x3 >= 2)
    model.addConstr(2*x4 >= 2)
    model.addConstr(x1 + 2*x3 >= 17)
    model.addConstr((2*x3)**2 + (2*x4)**2 >= 17)
    model.addConstr(x1 + 5*x2 >= 12)
    model.addConstr(x1 + 5*x2 + 2*x3 + 2*x4 >= 12)
    model.addConstr(-5*x1 + 3*x2 >= 0)
    model.addConstr(-x1**2 + 2*x3**2 >= 0)
    model.addConstr(-2*x2 + 5*x3 + 2*x4 >= 0)
    model.addConstr(x1 + 2*x4 <= 29)
    model.addConstr(x1 + 5*x2 <= 23)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B3: {x1.varValue}")
        print(f"Grams of fiber: {x2.varValue}")
        print(f"Milligrams of vitamin K: {x3.varValue}")
        print(f"Grams of carbohydrates: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
