
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bill_hours = model.addVar(lb=0, name="bill_hours")
    ringo_hours = model.addVar(lb=0, name="ringo_hours")
    bobby_hours = model.addVar(lb=0, name="bobby_hours")
    jean_hours = model.addVar(lb=0, name="jean_hours")

    # Set objective function
    model.setObjective(8.78*bill_hours**2 + 3.25*bill_hours*jean_hours + 2.78*bobby_hours*jean_hours + 6.85*ringo_hours + 5.71*bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10*bobby_hours + 10*jean_hours >= 32)
    model.addConstr(10*bill_hours + 14*bobby_hours >= 72)
    model.addConstr(19*ringo_hours + 14*bobby_hours >= 68)
    model.addConstr(19*ringo_hours + 14*bobby_hours + 10*jean_hours >= 88)
    model.addConstr(10*bill_hours + 14*bobby_hours + 10*jean_hours >= 88)
    model.addConstr(10*bill_hours + 19*ringo_hours + 14*bobby_hours >= 88)
    model.addConstr(19*ringo_hours + 14*bobby_hours + 10*jean_hours >= 57)
    model.addConstr(10*bill_hours + 14*bobby_hours + 10*jean_hours >= 57)
    model.addConstr(10*bill_hours + 19*ringo_hours + 14*bobby_hours >= 57)
    model.addConstr(19*ringo_hours**2 + 14*bobby_hours**2 + 10*jean_hours**2 >= 83)
    model.addConstr(10*bill_hours**2 + 14*bobby_hours**2 + 10*jean_hours**2 >= 83)
    model.addConstr(10*bill_hours + 19*ringo_hours + 14*bobby_hours >= 83)
    model.addConstr(10*bill_hours + 10*jean_hours <= 283)
    model.addConstr(19*ringo_hours + 10*jean_hours <= 331)
    model.addConstr(19*ringo_hours + 14*bobby_hours <= 105)
    model.addConstr(10*bill_hours + 14*bobby_hours <= 161)
    model.addConstr(10*bill_hours**2 + 14*bobby_hours**2 + 10*jean_hours**2 <= 210)
    model.addConstr(10*bill_hours + 19*ringo_hours + 10*jean_hours <= 216)
    model.addConstr(19*ringo_hours**2 + 14*bobby_hours**2 + 10*jean_hours**2 <= 253)
    model.addConstr(10*bill_hours + 19*ringo_hours + 14*bobby_hours + 10*jean_hours <= 253)
    model.addConstr(15*bill_hours**2 + 17*ringo_hours**2 <= 62)
    model.addConstr(17*ringo_hours**2 + 15*bobby_hours**2 <= 159)
    model.addConstr(15*bobby_hours + 20*jean_hours <= 60)
    model.addConstr(15*bill_hours + 15*bobby_hours <= 153)
    model.addConstr(15*bill_hours**2 + 17*ringo_hours**2 + 15*bobby_hours**2 <= 146)
    model.addConstr(15*bill_hours + 17*ringo_hours + 15*bobby_hours + 20*jean_hours <= 146)
    model.addConstr(21*ringo_hours + 3*jean_hours <= 333)
    model.addConstr(21*ringo_hours**2 + 16*bobby_hours**2 <= 149)
    model.addConstr(16*bill_hours + 16*bobby_hours <= 240)
    model.addConstr(16*bill_hours + 21*ringo_hours + 16*bobby_hours + 3*jean_hours <= 240)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
