
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="hours_worked_by_Ringo", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="hours_worked_by_Bobby", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="hours_worked_by_Jean", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(8.78 * x0**2 + 3.25 * x0 * x3 + 2.78 * x2 * x3 + 6.85 * x1 + 5.71 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(10 * x0 <= 362)
m.addConstr(15 * x0 <= 185)
m.addConstr(16 * x0 <= 374)
m.addConstr(19 * x1 <= 362)
m.addConstr(17 * x1 <= 185)
m.addConstr(21 * x1 <= 374)
m.addConstr(14 * x2 <= 362)
m.addConstr(15 * x2 <= 185)
m.addConstr(16 * x2 <= 374)
m.addConstr(10 * x3 <= 362)
m.addConstr(20 * x3 <= 185)
m.addConstr(3 * x3 <= 374)
m.addConstr(14 * x2 + 10 * x3 >= 32)
m.addConstr(10 * x0 + 14 * x2 >= 72)
m.addConstr(19 * x1 + 14 * x2 >= 68)
m.addConstr(19 * x1 + 14 * x2 + 10 * x3 >= 88)
m.addConstr(10 * x0 + 14 * x2 + 10 * x3 >= 88)
m.addConstr(10 * x0 + 19 * x1 + 14 * x2 >= 88)
m.addConstr(19 * x1 + 14 * x2 + 10 * x3 >= 57)
m.addConstr(10 * x0 + 14 * x2 + 10 * x3 >= 57)
m.addConstr(10 * x0 + 19 * x1 + 14 * x2 >= 57)
m.addConstr(19 * x1**2 + 14 * x2**2 + 10 * x3**2 >= 83)
m.addConstr(10 * x0**2 + 14 * x2**2 + 10 * x3**2 >= 83)
m.addConstr(10 * x0 + 19 * x1 + 14 * x2 >= 83)
m.addConstr(10 * x0 + 10 * x3 <= 283)
m.addConstr(19 * x1 + 10 * x3 <= 331)
m.addConstr(19 * x1 + 14 * x2 <= 105)
m.addConstr(10 * x0 + 14 * x2 <= 161)
m.addConstr(10 * x0**2 + 14 * x2**2 + 10 * x3**2 <= 210)
m.addConstr(10 * x0 + 19 * x1 + 10 * x3 <= 216)
m.addConstr(19 * x1**2 + 14 * x2**2 + 10 * x3**2 <= 253)
m.addConstr(10 * x0 + 19 * x1 + 14 * x2 + 10 * x3 <= 253)
m.addConstr(15 * x0**2 + 17 * x1**2 <= 62)
m.addConstr(17 * x1**2 + 15 * x2**2 <= 159)
m.addConstr(15 * x2 + 20 * x3 <= 60)
m.addConstr(15 * x0 + 15 * x2 <= 153)
m.addConstr(15 * x0**2 + 17 * x1**2 + 15 * x2**2 <= 146)
m.addConstr(15 * x0 + 17 * x1 + 15 * x2 + 20 * x3 <= 146)
m.addConstr(21 * x1 + 3 * x3 <= 333)
m.addConstr(21 * x1**2 + 16 * x2**2 <= 149)
m.addConstr(16 * x0 + 16 * x2 <= 240)
m.addConstr(16 * x0 + 21 * x1 + 16 * x2 + 3 * x3 <= 240)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Ringo: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
    print("Hours worked by Jean: ", x3.varValue)
else:
    print("The model is infeasible")
