
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B7
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B12


    # Set objective function
    model.setObjective(1*x0 + 4*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18*x0 + 23*x1 >= 27, "c0")
    model.addConstr(8*x0 + 29*x1 >= 51, "c1")
    model.addConstr(15*x0 + 21*x1 >= 51, "c2")
    model.addConstr(3*x0 + 17*x1 >= 27, "c3")
    model.addConstr(20*x0 + 22*x1 >= 18, "c4")
    model.addConstr(3*x0 - 7*x1 >= 0, "c5")
    model.addConstr(18*x0 + 23*x1 <= 89, "c6")
    model.addConstr(8*x0 + 29*x1 <= 191, "c7")
    model.addConstr(15*x0 + 21*x1 <= 88, "c8")
    model.addConstr(3*x0 + 17*x1 <= 71, "c9")
    model.addConstr(20*x0 + 22*x1 <= 52, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
