
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B7
x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B12

# Objective function
model.setObjective(x0 + 4 * x1, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(18 * x0 + 23 * x1 >= 27, name="immune_support_min")
model.addConstr(18 * x0 + 23 * x1 <= 89, name="immune_support_max")
model.addConstr(8 * x0 + 29 * x1 >= 51, name="cognitive_performance_min")
model.addConstr(8 * x0 + 29 * x1 <= 191, name="cognitive_performance_max")
model.addConstr(15 * x0 + 21 * x1 >= 51, name="digestive_support_min")
model.addConstr(15 * x0 + 21 * x1 <= 88, name="digestive_support_max")
model.addConstr(3 * x0 + 17 * x1 >= 27, name="kidney_support_min")
model.addConstr(3 * x0 + 17 * x1 <= 71, name="kidney_support_max")
model.addConstr(20 * x0 + 22 * x1 >= 18, name="energy_stability_min")
model.addConstr(20 * x0 + 22 * x1 <= 52, name="energy_stability_max")
model.addConstr(3 * x0 - 7 * x1 >= 0, name="additional_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B7: {x0.varValue}")
    print(f"Milligrams of vitamin B12: {x1.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
