
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = {}
item_names = ['bowls of pasta', 'steaks', 'strawberries', 'ravioli', 'slices of pizza', 'eggs', 'cherry pies']
for i in range(len(item_names)):
    x[i] = m.addVar(vtype=gp.GRB.INTEGER, name=item_names[i])


# Set objective function
m.setObjective(2.93 * x[0] + 9.39 * x[1] + 2.32 * x[2] + 8.75 * x[3] + 6.23 * x[4] + 4.52 * x[5] + 1.54 * x[6], gp.GRB.MINIMIZE)

# Add constraints
iron_content = {'r0': {'x0': 3.78, 'x1': 5.09, 'x2': 8.37, 'x3': 6.04, 'x4': 5.1, 'x5': 1.02, 'x6': 2.68}}

m.addConstr(iron_content['r0']['x2'] * x[2] + iron_content['r0']['x6'] * x[6] >= 45)
m.addConstr(iron_content['r0']['x4'] * x[4] + iron_content['r0']['x6'] * x[6] >= 44)
m.addConstr(iron_content['r0']['x5'] * x[5] + iron_content['r0']['x6'] * x[6] >= 64)
m.addConstr(iron_content['r0']['x2'] * x[2] + iron_content['r0']['x5'] * x[5] >= 71)
m.addConstr(iron_content['r0']['x1'] * x[1] + iron_content['r0']['x2'] * x[2] + iron_content['r0']['x4'] * x[4] >= 45)
m.addConstr(iron_content['r0']['x2'] * x[2] + iron_content['r0']['x3'] * x[3] + iron_content['r0']['x5'] * x[5] >= 45)


#Iron Upper Bound
m.addConstr(sum(iron_content['r0']['x' + str(i)] * x[i] for i in range(7)) <= 519)

# Additional constraints (simplified for brevity - add all your constraints here)
m.addConstr(-2 * x[2] + 8 * x[4] >= 0)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

