
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")
    x1 = model.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")


    # Set objective function
    model.setObjective(8.61*x0**2 + 8.54*x0*x1 + 1.04*x1**2 + 3.32*x0 + 8.36*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(17*x0 + 6*x1 <= 152, "c0")
    model.addConstr(17*x0 + 6*x1 >= 49, "c1")
    model.addConstr(3*x0**2 - 9*x1**2 >= 0, "c2")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Hours worked by Jean: {x0.x}")
        print(f"Hours worked by George: {x1.x}")
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
