
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_jean")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_george")

# Set objective function
m.setObjective(8.61*x1**2 + 8.54*x1*x2 + 1.04*x2**2 + 3.32*x1 + 8.36*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1**2 + x2**2 >= 49, "minimum_work_quality")
m.addConstr(3*x1**2 - 9*x2**2 >= 0, "work_balance")
m.addConstr(17*x1 + 6*x2 <= 152, "maximum_total_rating")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Hours worked by George: {x2.x}")
else:
    print("No optimal solution found")
