
import gurobi

def optimize_problem():
    try:
        # Create a new model
        m = gurobi.Model()

        # Define variables
        x1 = m.addVar(name="hours_worked_by_Jean", vtype=gurobi.GRB.INTEGER)
        x2 = m.addVar(name="hours_worked_by_George", vtype=gurobi.GRB.INTEGER)

        # Objective function
        m.setObjective(8.61*x1**2 + 8.54*x1*x2 + 1.04*x2**2 + 3.32*x1 + 8.36*x2, gurobi.GRB.MAXIMIZE)

        # Constraints
        m.addConstr(x1**2 + x2**2 >= 49)
        m.addConstr(3*x1**2 - 9*x2**2 >= 0)
        m.addConstr(x1 + x2 <= 152)

        # Non-negativity constraints (implicit in Gurobi for continuous variables, but we make sure)
        # Not needed explicitly for integer variables as they default to 0 lower bound

        # Solve the problem
        m.optimize()

        # Print the solution
        if m.status == gurobi.GRB.OPTIMAL:
            print("Optimal solution found.")
            print(f"Hours worked by Jean: {x1.varValue}")
            print(f"Hours worked by George: {x2.varValue}")
            print(f"Objective: {m.objVal}")
        else:
            print("No optimal solution found.")

    except gurobi.GUROBI_ERROR as e:
        print(f"Gurobi error: {e}")

optimize_problem()
