
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein bars")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls of instant ramen")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")


    # Set objective function
    m.setObjective(2*x0 + 6*x1 + 6*x2 + 1*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 1*x3 >= 53)
    m.addConstr(7*x0 + 6*x2 >= 43)
    m.addConstr(7*x0 + 11*x1 >= 47)
    m.addConstr(11*x1 + 1*x3 >= 52)
    m.addConstr(7*x0 + 11*x1 + 6*x2 + 1*x3 >= 52)
    m.addConstr(4*x0 + 25*x1 >= 18)
    m.addConstr(4*x0 + 25*x1 + 26*x2 + 29*x3 >= 18)
    m.addConstr(7*x0 + 6*x2 <= 168)
    m.addConstr(7*x0 + 1*x3 <= 109)
    m.addConstr(4*x0 + 26*x2 + 29*x3 <= 86)
    m.addConstr(4*x0 + 25*x1 + 26*x2 <= 48)
    m.addConstr(7*x0 + 11*x1 + 6*x2 + 1*x3 <= 217)
    m.addConstr(4*x0 + 25*x1 + 26*x2 + 29*x3 <= 125)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
