
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # oreos
    x1 = model.addVar(name="x1", lb=0)  # protein bars
    x2 = model.addVar(name="x2", lb=0)  # bowls of instant ramen
    x3 = model.addVar(name="x3", lb=0)  # tomatoes

    # Objective function
    model.setObjective(2*x0 + 6*x1 + 6*x2 + x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7*x0 <= 217)
    model.addConstr(11*x1 <= 217)
    model.addConstr(6*x2 <= 217)
    model.addConstr(x3 <= 217)
    model.addConstr(4*x0 <= 125)
    model.addConstr(25*x1 <= 125)
    model.addConstr(26*x2 <= 125)
    model.addConstr(29*x3 <= 125)

    model.addConstr(7*x0 + x3 >= 53)
    model.addConstr(7*x0 + 6*x2 >= 43)
    model.addConstr(7*x0 + 11*x1 >= 47)
    model.addConstr(11*x1 + x3 >= 52)
    model.addConstr(7*x0 + 11*x1 + 6*x2 + x3 >= 52)
    model.addConstr(4*x0 + 25*x1 >= 18)
    model.addConstr(4*x0 + 25*x1 + 26*x2 + 29*x3 >= 18)
    model.addConstr(7*x0 + 6*x2 <= 168)
    model.addConstr(7*x0 + x3 <= 109)
    model.addConstr(4*x0 + 26*x2 + 29*x3 <= 86)
    model.addConstr(4*x0 + 25*x1 + 26*x2 <= 48)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Oreos: ", x0.varValue)
        print("Protein bars: ", x1.varValue)
        print("Bowls of instant ramen: ", x2.varValue)
        print("Tomatoes: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
