
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype='C', name='x0') # milligrams of vitamin B9
    x1 = m.addVar(lb=0, vtype='C', name='x1') # milligrams of calcium
    x2 = m.addVar(lb=0, vtype='C', name='x2') # milligrams of vitamin B3
    x3 = m.addVar(lb=0, vtype='C', name='x3') # milligrams of vitamin B2


    # Set objective function
    m.setObjective(9*x0 + 3*x1 + 8*x2 + 4*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 4*x1 + 10*x2 + 6*x3 <= 296)
    m.addConstr(2*x0 + 5*x1 + x2 + x3 <= 253)
    m.addConstr(11*x0 + 3*x1 + 2*x2 + 10*x3 <= 70)
    m.addConstr(4*x1 + 6*x3 >= 60)
    m.addConstr(7*x0 + 6*x3 >= 35)
    m.addConstr(7*x0 + 10*x2 >= 67)
    m.addConstr(4*x1 + 10*x2 >= 24)
    m.addConstr(7*x0 + 4*x1 + 6*x3 >= 73)
    m.addConstr(7*x0 + 10*x2 + 6*x3 >= 73)
    m.addConstr(4*x1 + 10*x2 + 6*x3 >= 73)
    m.addConstr(7*x0 + 4*x1 + 6*x3 >= 56)
    m.addConstr(7*x0 + 10*x2 + 6*x3 >= 56)
    m.addConstr(4*x1 + 10*x2 + 6*x3 >= 56)
    m.addConstr(7*x0 + 4*x1 + 6*x3 >= 47)
    m.addConstr(7*x0 + 10*x2 + 6*x3 >= 47)
    m.addConstr(4*x1 + 10*x2 + 6*x3 >= 47)
    m.addConstr(7*x0 + 4*x1 + 10*x2 + 6*x3 >= 47)
    m.addConstr(2*x0 + x2 >= 30)
    m.addConstr(2*x0 + x3 >= 37)
    m.addConstr(2*x0 + 5*x1 + x3 >= 41)
    m.addConstr(2*x0 + 5*x1 + x2 + x3 >= 41)
    m.addConstr(3*x1 + 2*x2 >= 15)
    m.addConstr(11*x0 + 10*x3 >= 7)
    m.addConstr(11*x0 + 3*x1 >= 10)
    m.addConstr(3*x1 + 2*x2 + 10*x3 >= 12)
    m.addConstr(11*x0 + 3*x1 + 2*x2 >= 12)
    m.addConstr(3*x1 + 2*x2 + 10*x3 >= 12)
    m.addConstr(11*x0 + 3*x1 + 2*x2 >= 12)
    m.addConstr(11*x0 + 3*x1 + 2*x2 + 10*x3 >= 12)
    m.addConstr(4*x0 - 6*x1 >= 0)
    m.addConstr(4*x1 - 4*x2 >= 0)
    m.addConstr(4*x1 + 10*x2 <= 265)
    m.addConstr(7*x0 + 6*x3 <= 114)
    m.addConstr(10*x2 + 6*x3 <= 142)
    m.addConstr(5*x1 + x2 <= 236)
    m.addConstr(2*x0 + x2 <= 196)
    m.addConstr(5*x1 + x3 <= 133)
    m.addConstr(11*x0 + 2*x2 <= 20)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
