
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
    protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")

    # Set objective function
    m.setObjective(5 * potatoes + 2 * protein_bars, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * potatoes + 7 * protein_bars >= 31, "healthiness_min")
    m.addConstr(2 * potatoes + 1 * protein_bars >= 20, "tastiness_min")
    m.addConstr(8 * potatoes + 10 * protein_bars >= 24, "fiber_min")
    m.addConstr(9 * potatoes - 1 * protein_bars >= 0, "potato_protein_ratio")

    m.addConstr(5 * potatoes + 7 * protein_bars <= 71, "healthiness_max1")
    m.addConstr(2 * potatoes + 1 * protein_bars <= 52, "tastiness_max1")
    m.addConstr(8 * potatoes + 10 * protein_bars <= 54, "fiber_max1")

    m.addConstr(5 * potatoes + 7 * protein_bars <= 52, "healthiness_max2")
    m.addConstr(2 * potatoes + 1 * protein_bars <= 50, "tastiness_max2")
    m.addConstr(8 * potatoes + 10 * protein_bars <= 30, "fiber_max2")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('potatoes:', potatoes.x)
        print('protein_bars:', protein_bars.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
