
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")

# Set the objective function
m.setObjective(5*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 7*x2 >= 31, "healthiness_rating_constraint")
m.addConstr(2*x1 + x2 >= 20, "tastiness_rating_constraint")
m.addConstr(8*x1 + 10*x2 >= 24, "fiber_constraint")
m.addConstr(9*x1 - x2 >= 0, "linear_combination_constraint")
m.addConstr(5*x1 + 7*x2 <= 52, "upper_bound_healthiness_rating")
m.addConstr(2*x1 + x2 <= 50, "upper_bound_tastiness_rating")
m.addConstr(8*x1 + 10*x2 <= 30, "upper_bound_fiber")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {x1.x}")
    print(f"Protein Bars: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
