
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B7")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_K")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")


# Set objective function
m.setObjective(7*x0 + 2*x1 + 5*x2 + 3*x3 + 9*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18*x0 + 7*x1 + 6*x2 + 18*x3 + 13*x4 <= 382, "kidney_support_index_total")
m.addConstr(19*x0 + 11*x1 + 2*x2 + 6*x3 + 6*x4 <= 464, "energy_stability_index_total")
m.addConstr(14*x0 + 13*x1 + 12*x2 + 17*x3 + 6*x4 <= 170, "immune_support_index_total")

# ... (rest of the constraints from the JSON "constraints" section)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

