
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of zinc
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin K
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B3
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin A
    x4 = model.addVar(name="x4", lb=-gurobi.GRB.INFINITY)  # grams of fiber

    # Objective function
    model.setObjective(4 * x0 + x1 + 2 * x2 + x3 + 2 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14 * x0 <= 213)
    model.addConstr(15 * x0 <= 179)
    model.addConstr(13 * x0 <= 239)
    model.addConstr(4 * x1 <= 213)
    model.addConstr(18 * x1 <= 179)
    model.addConstr(6 * x1 <= 239)
    model.addConstr(15 * x2 <= 213)
    model.addConstr(13 * x2 <= 179)
    model.addConstr(9 * x2 <= 239)
    model.addConstr(2 * x3 <= 213)
    model.addConstr(4 * x3 <= 179)
    model.addConstr(19 * x3 <= 239)
    model.addConstr(5 * x4 <= 213)
    model.addConstr(10 * x4 <= 179)
    model.addConstr(15 * x4 <= 239)

    model.addConstr(4 * x1 + 15 * x2 >= 24)
    model.addConstr(14 * x0 + 4 * x1 >= 34)
    model.addConstr(14 * x0 + 2 * x3 >= 22)
    model.addConstr(4 * x1 + 5 * x4 >= 41)
    model.addConstr(2 * x3 + 5 * x4 >= 23)
    model.addConstr(15 * x2 + 5 * x4 >= 31)
    model.addConstr(14 * x0 + 15 * x2 >= 41)
    model.addConstr(14 * x0 + 15 * x2 + 2 * x3 >= 36)
    model.addConstr(15 * x2 + 2 * x3 + 5 * x4 >= 36)
    model.addConstr(4 * x1 + 2 * x3 + 5 * x4 >= 36)
    model.addConstr(4 * x1 + 15 * x2 + 2 * x3 >= 36)
    model.addConstr(14 * x0 + 15 * x2 + 2 * x3 >= 28)
    model.addConstr(15 * x2 + 2 * x3 + 5 * x4 >= 28)
    model.addConstr(4 * x1 + 2 * x3 + 5 * x4 >= 28)
    model.addConstr(4 * x1 + 15 * x2 + 2 * x3 >= 28)
    model.addConstr(14 * x0 + 15 * x2 + 2 * x3 >= 26)
    model.addConstr(15 * x2 + 2 * x3 + 5 * x4 >= 26)
    model.addConstr(4 * x1 + 2 * x3 + 5 * x4 >= 26)
    model.addConstr(4 * x1 + 15 * x2 + 2 * x3 >= 26)
    model.addConstr(14 * x0 + 15 * x2 + 2 * x3 >= 26)
    model.addConstr(14 * x0 + 4 * x1 + 15 * x2 + 2 * x3 + 5 * x4 >= 26)

    model.addConstr(18 * x1 + 10 * x4 >= 20)
    model.addConstr(13 * x2 + 4 * x3 >= 22)
    model.addConstr(15 * x0 + 13 * x2 >= 18)
    model.addConstr(15 * x0 + 10 * x4 >= 13)
    model.addConstr(18 * x1 + 4 * x3 >= 15)
    model.addConstr(15 * x0 + 4 * x3 >= 20)
    model.addConstr(15 * x0 + 18 * x1 + 4 * x3 >= 17)
    model.addConstr(15 * x0 + 13 * x2 + 10 * x4 >= 17)
    model.addConstr(18 * x1 + 13 * x2 + 10 * x4 >= 17)
    model.addConstr(15 * x0 + 13 * x2 + 4 * x3 >= 17)

    model.addConstr(13 * x0 + 19 * x3 >= 42)
    model.addConstr(9 * x2 + 19 * x3 >= 16)
    model.addConstr(6 * x1 + 15 * x4 >= 26)
    model.addConstr(13 * x0 + 6 * x1 + 9 * x2 + 19 * x3 + 15 * x4 >= 26)

    model.addConstr(-4 * x2 + 7 * x3 >= 0)
    model.addConstr(15 * x2 + 2 * x3 <= 93)
    model.addConstr(4 * x1 + 15 * x2 <= 192)
    model.addConstr(4 * x1 + 2 * x3 <= 128)
    model.addConstr(14 * x0 + 5 * x4 <= 57)
    model.addConstr(2 * x3 + 5 * x4 <= 120)
    model.addConstr(4 * x1 + 5 * x4 <= 137)
    model.addConstr(14 * x0 + 4 * x1 <= 163)
    model.addConstr(14 * x0 + 4 * x1 + 5 * x4 <= 191)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
