
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")
eggs = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")

# Set objective function
m.setObjective(3*cherry_pies**2 + 6*cherry_pies*eggs + 4*cherry_pies*green_beans + eggs**2 + 3*eggs*green_beans + 9*green_beans**2 + 5*cherry_pies + eggs + 8*green_beans, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*cherry_pies + 6*eggs >= 21)
m.addConstr(5*cherry_pies + 6*eggs + 3*green_beans >= 20)
m.addConstr(7*eggs + 2*green_beans >= 24)
m.addConstr(2*cherry_pies + 7*eggs >= 46)
m.addConstr(2*cherry_pies + 7*eggs + 2*green_beans >= 46)
m.addConstr(4*cherry_pies**2 + 7*green_beans**2 >= 26)
m.addConstr(4*cherry_pies + 8*eggs >= 43)
m.addConstr(4*cherry_pies + 8*eggs + 7*green_beans >= 43)
m.addConstr(5*cherry_pies + 3*green_beans >= 14)
m.addConstr(5*cherry_pies + eggs >= 12)
m.addConstr(5*cherry_pies + eggs + 3*green_beans >= 8)
m.addConstr(4*cherry_pies + 4*green_beans >= 22)
m.addConstr(4*cherry_pies + 10*eggs >= 33)
m.addConstr(4*cherry_pies + 10*eggs + 4*green_beans >= 33)
m.addConstr(10*cherry_pies**2 - eggs**2 >= 0)
m.addConstr(-eggs + 8*green_beans >= 0)
m.addConstr(5*cherry_pies + 6*eggs + 3*green_beans <= 41)
m.addConstr(2*cherry_pies + 7*eggs <= 61)
m.addConstr(8*eggs + 7*green_beans <= 111)
m.addConstr(4*cherry_pies + 7*green_beans <= 94)
m.addConstr(4*cherry_pies + 8*eggs <= 49)
m.addConstr(eggs**2 + 3*green_beans**2 <= 30)
m.addConstr(4*cherry_pies + 10*eggs <= 76)
m.addConstr(4*cherry_pies + 10*eggs + 4*green_beans <= 97)


# Resource Constraints
m.addConstr(5*cherry_pies <= 67)
m.addConstr(2*cherry_pies <= 144)
m.addConstr(4*cherry_pies <= 143)
m.addConstr(5*cherry_pies <= 42)
m.addConstr(4*cherry_pies <= 162)
m.addConstr(6*eggs <= 67)
m.addConstr(7*eggs <= 144)
m.addConstr(8*eggs <= 143)
m.addConstr(eggs <= 42)
m.addConstr(10*eggs <= 162)
m.addConstr(3*green_beans <= 67)
m.addConstr(2*green_beans <= 144)
m.addConstr(7*green_beans <= 143)
m.addConstr(3*green_beans <= 42)
m.addConstr(4*green_beans <= 162)



# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cherry_pies:', cherry_pies.x)
    print('eggs:', eggs.x)
    print('green_beans:', green_beans.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
