
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Dale
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # hours worked by George


    # Set objective function
    model.setObjective(7*x0 + 4*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7.09*x0 + 5.38*x1 >= 49, "c0")
    model.addConstr(4.11*x0 + 6.11*x1 >= 45, "c1")
    model.addConstr(2.68*x0 + 4.9*x1 >= 95, "c2")
    model.addConstr(0.85*x0 + 3.05*x1 >= 63, "c3")
    model.addConstr(-10*x0 + 3*x1 >= 0, "c4")
    model.addConstr(7.09*x0 + 5.38*x1 <= 119, "c5")
    model.addConstr(4.11*x0 + 6.11*x1 <= 109, "c6")
    model.addConstr(2.68*x0 + 4.9*x1 <= 169, "c7")
    model.addConstr(0.85*x0 + 3.05*x1 <= 109, "c8")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"x0 (hours worked by Dale): {x0.x}")
        print(f"x1 (hours worked by George): {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model has been optimized.")

