
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Dale", lb=0)  # Dale can work fractional hours
x2 = m.addVar(name="hours_worked_by_George", vtype=gp.GRB.INTEGER)  # George can only work integer hours

# Define the objective function
m.setObjective(7 * x1 + 4 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7.09 * x1 + 5.38 * x2 >= 49)
m.addConstr(4.11 * x1 + 6.11 * x2 >= 45)
m.addConstr(2.68 * x1 + 4.9 * x2 >= 95)
m.addConstr(0.85 * x1 + 3.05 * x2 >= 63)
m.addConstr(-10 * x1 + 3 * x2 >= 0)
m.addConstr(7.09 * x1 + 5.38 * x2 <= 119)
m.addConstr(4.11 * x1 + 6.11 * x2 <= 109)
m.addConstr(2.68 * x1 + 4.9 * x2 <= 169)
m.addConstr(0.85 * x1 + 3.05 * x2 <= 109)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
