
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Bill")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Bobby")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Paul")


    # Set objective function
    m.setObjective(3*x0 + 3*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*x0 + 12*x2 >= 11, "c0")
    m.addConstr(11*x1 + 12*x2 >= 11, "c1")
    m.addConstr(2*x0 + 11*x1 + 12*x2 >= 11, "c2")
    m.addConstr(10*x1 + 10*x2 >= 24, "c3")
    m.addConstr(12*x0 + 10*x1 >= 37, "c4")
    m.addConstr(12*x0 + 10*x2 >= 22, "c5")
    m.addConstr(12*x0 + 10*x1 + 10*x2 >= 37, "c6")
    m.addConstr(12*x0 + 10*x1 + 10*x2 >= 37, "c7")
    m.addConstr(1*x0 - 10*x1 >= 0, "c8")
    m.addConstr(2*x0 + 11*x1 <= 51, "c9")
    m.addConstr(2*x0 + 11*x1 + 12*x2 <= 29, "c10")
    m.addConstr(12*x0 + 10*x2 <= 53, "c11")
    m.addConstr(12*x0 + 10*x1 + 10*x2 <= 141, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
