
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=0)
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x2 = m.addVar(name="hours_worked_by_Paul", lb=0)

# Set the objective function
m.setObjective(3*x0 + 3*x1 + x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 <= 74)
m.addConstr(12*x0 <= 145)
m.addConstr(11*x1 <= 74)
m.addConstr(10*x1 <= 145)
m.addConstr(12*x2 <= 74)
m.addConstr(10*x2 <= 145)
m.addConstr(2*x0 + 12*x2 >= 11)
m.addConstr(11*x1 + 12*x2 >= 11)
m.addConstr(2*x0 + 11*x1 + 12*x2 >= 11)
m.addConstr(10*x1 + 10*x2 >= 24)
m.addConstr(12*x0 + 10*x1 >= 37)
m.addConstr(12*x0 + 10*x2 >= 22)
m.addConstr(12*x0 + 10*x1 + 10*x2 >= 37)
m.addConstr(12*x0 + 10*x1 + 10*x2 <= 141)
m.addConstr(x0 - 10*x1 >= 0)
m.addConstr(2*x0 + 11*x1 <= 51)
m.addConstr(2*x0 + 11*x1 + 12*x2 <= 29)
m.addConstr(12*x0 + 10*x2 <= 53)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Bobby: ", x1.varValue)
    print("Hours worked by Paul: ", x2.varValue)
else:
    print("The model is infeasible")
