
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("minimize_food_cost")

    # Create variables
    kale_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")
    chicken_thighs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")


    # Set objective function
    m.setObjective(2 * kale_salads + 9 * chicken_thighs, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * kale_salads + 14 * chicken_thighs >= 45, "protein_lower_bound")
    m.addConstr(7 * kale_salads + 1 * chicken_thighs >= 22, "healthiness_lower_bound")
    m.addConstr(-10 * kale_salads + 7 * chicken_thighs >= 0, "kale_chicken_ratio")
    m.addConstr(2 * kale_salads + 14 * chicken_thighs <= 94, "protein_upper_bound")
    m.addConstr(7 * kale_salads + 1 * chicken_thighs <= 55, "healthiness_upper_bound")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print(f"Optimal objective value: {m.objVal}")
        print(f"Kale salads: {kale_salads.x}")
        print(f"Chicken thighs: {chicken_thighs.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
