
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")

# Set the objective function
m.setObjective(2*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 14*x2 >= 45, "protein_min")
m.addConstr(7*x1 + x2 >= 22, "healthiness_min")
m.addConstr(-10*x1 + 7*x2 >= 0, "custom_constraint")
m.addConstr(2*x1 + 14*x2 <= 94, "protein_max")
m.addConstr(7*x1 + x2 <= 55, "healthiness_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kale Salads: {x1.x}")
    print(f"Chicken Thighs: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
