
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='kale_salads', lb=0)  # Assuming non-negative
    x2 = model.addVar(name='chicken_thighs', lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(2*x1 + 9*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(2*x1 + 14*x2 >= 45, name='protein_min')
    model.addConstr(2*x1 + 14*x2 <= 94, name='protein_max')
    model.addConstr(7*x1 + x2 >= 22, name='healthiness_min')
    model.addConstr(7*x1 + x2 <= 55, name='healthiness_max')
    model.addConstr(-10*x1 + 7*x2 >= 0, name='linear_combination')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Kale Salads: ', x1.varValue)
        print('Chicken Thighs: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
