
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    m.setObjective(1.1*x0**2 + 4.45*x1**2 + 7.36*x2**2 + 3.64*x0 + 2.76*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 4*x1 + 16*x2 <= 218, "c0")
    m.addConstr(x0 + 12*x1 + 21*x2 <= 177, "c1")
    m.addConstr(23*x0 + 10*x1 + 14*x2 <= 289, "c2")
    m.addConstr(4*x1 + 16*x2 >= 26, "c3")
    m.addConstr(13*x0 + 16*x2 >= 24, "c4")
    m.addConstr(x0 + 21*x2 >= 43, "c5")
    m.addConstr(12*x1**2 + 21*x2**2 >= 35, "c6")
    m.addConstr(10*x1 + 14*x2 >= 78, "c7")
    m.addConstr(23*x0 + 14*x2 >= 37, "c8")
    m.addConstr(13*x0 + 4*x1 <= 126, "c9")
    m.addConstr(13*x0 + 16*x2 <= 110, "c10")
    m.addConstr(13*x0 + 4*x1 + 16*x2 <= 110, "c11")
    m.addConstr(12*x1 + 21*x2 <= 157, "c12")
    m.addConstr(x0 + 12*x1 <= 157, "c13")
    m.addConstr(x0 + 12*x1 + 21*x2 <= 157, "c14")
    m.addConstr(10*x1**2 + 14*x2**2 <= 231, "c15")
    m.addConstr(23*x0**2 + 14*x2**2 <= 105, "c16")
    m.addConstr(23*x0 + 10*x1 + 14*x2 <= 105, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
