
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams of iron", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="milligrams of vitamin B9", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams of vitamin B12", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(1.1*x0**2 + 4.45*x1**2 + 7.36*x2**2 + 3.64*x0 + 2.76*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x0 <= 218)
    model.addConstr(x0 <= 177)
    model.addConstr(23*x0 <= 289)
    model.addConstr(4*x1 <= 218)
    model.addConstr(12*x1 <= 177)
    model.addConstr(10*x1 <= 289)
    model.addConstr(16*x2 <= 218)
    model.addConstr(21*x2 <= 177)
    model.addConstr(14*x2 <= 289)
    model.addConstr(4*x1 + 16*x2 >= 26)
    model.addConstr(13*x0 + 16*x2 >= 24)
    model.addConstr(x0 + 21*x2 >= 43)
    model.addConstr(144*x1**2 + 441*x2**2 >= 35)
    model.addConstr(10*x1 + 14*x2 >= 78)
    model.addConstr(23*x0 + 14*x2 >= 37)
    model.addConstr(13*x0 + 4*x1 <= 126)
    model.addConstr(13*x0 + 16*x2 <= 110)
    model.addConstr(13*x0 + 4*x1 + 16*x2 <= 110)
    model.addConstr(12*x1 + 21*x2 <= 157)
    model.addConstr(x0 + 12*x1 <= 157)
    model.addConstr(x0 + 12*x1 + 21*x2 <= 157)
    model.addConstr(100*x1**2 + 196*x2**2 <= 231)
    model.addConstr(529*x0**2 + 196*x2**2 <= 105)
    model.addConstr(23*x0 + 10*x1 + 14*x2 <= 105)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x0.varValue}")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of vitamin B12: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
